#!/usr/bin/bash

# [percetion_overtake, perception_red_light, perception_left_turn,
# [neogotiation_overtake, negotiation_highway_merge, negotiation_highway_exit]
SCENARIO=perception_overtake
MODE=eval # [train_decentralized, train_centralized, eval]
AGENT_CONFIG=comm # [silent, comm]
POLICY_CONFIG=untrained # [untrained, tip, rag, debrief]
MODEL=llama #[gpt, llama]
ENV_CONFIG=${SCENARIO}_${AGENT_CONFIG}
EXP_CONFIG=${SCENARIO}/${ENV_CONFIG}_${POLICY_CONFIG}_${MODEL}
LOG_DIR=results/${SCENARIO}/${MODE}/${AGENT_CONFIG}_${POLICY_CONFIG}_${MODEL}/

NUM_EVAL_EPISODES=30
NUM_TRAIN_ITERATIONS=30
CKPT_NUM=-1  # -1 for latest checkpoint

echo "Running scenario: ${SCENARIO}"
echo "Running experiment: ${EXP_CONFIG}"
echo "Logging to: ${LOG_DIR}"

if [ $MODE == eval ]; then
    python eval/eval.py exp_config=${EXP_CONFIG} env_config=${ENV_CONFIG} logdir=${LOG_DIR} num_eval_episodes=${NUM_EVAL_EPISODES} checkpoint=${CKPT_NUM}
elif [ $MODE == train_decentralized ]; then
    python train/train_decentralized_llm.py exp_config=${EXP_CONFIG} env_config=${ENV_CONFIG} logdir=${LOG_DIR} num_train_iterations=${NUM_TRAIN_ITERATIONS}
elif [ $MODE == train_centralized ]; then
    python train/train_centralized_llm.py exp_config=${EXP_CONFIG} env_config=${ENV_CONFIG} logdir=${LOG_DIR} num_train_iterations=${NUM_TRAIN_ITERATIONS}
elif [ $MODE == train_coopernaut ]; then
    python train/train_coopernaut.py exp_config=${EXP_CONFIG} env_config=${ENV_CONFIG} logdir=${LOG_DIR} num_train_iterations=${NUM_TRAIN_ITERATIONS}
else
    echo "Invalid mode"
fi
